
size = [1 2 4 8 16 32 64 128 256 512 1024 ];
numtimes=1000;

disp('Ensuring Jacket has been initialized on all workers...');
spmd
    k = fft(grand(4));
    gforce(k);
end
k = fft(grand(4));
gforce(k);

disp('--- FFT, No Parallelization:');
for i=1:numel(size)
	tic; for j=1:numtimes
		fft(rand(size(i)));
	end; nognop(i)=toc;
    disp([num2str(size(i)) ': ' num2str(nognop(i))])
end

disp('--- FFT on GPU, No Parallelization:');
for i=1:numel(size)
	tic; for j=1:numtimes
		gforce(fft(grand(size(i)))); 
	end; nop(i) = toc;
    disp([num2str(size(i)) ': ' num2str(nop(i))])
end


disp('--- FFT, Parallelization:');
for i=1:numel(size)
	tic; parfor (j=1:numtimes)
		fft(rand(size(i)));
	end; nog(i) = toc;
    disp([num2str(size(i)) ': ' num2str(nog(i))])
end

disp('--- FFT on GPU, Parallelization:');
for i=1:numel(size)
	tic; parfor (j=1:numtimes)
		gforce(fft(grand(size(i)))); 
	end; pg(i)=toc;
    disp([num2str(size(i)) ': ' num2str(pg(i))])
end


c(1,:) = nognop(1:end);
c(2,:) = nog(1:end);
c(3,:) = nop(1:end);
c(4,:) = pg(1:end);

sp(1,:) = c(1,:)./c(1,:);
sp(2,:) = c(2,:)./c(1,:);
sp(3,:) = c(3,:)./c(1,:);
sp(4,:) = c(4,:)./c(1,:);

sp = 1 ./ sp;

plot(size, sp);
legend({'Single CPU', 'Multiple CPU', 'Single CPU with GPU', 'Multiple CPU with Multiple GPU'}, 'Location', 'Best');


