<?php
//error codes
define('ERROR_KEY', 'error:');
define("ERROR_SUCCESS",0);
define("ERROR_MISSING_PARAMS",-1);
define("ERROR_INVALID_PRODUCT",-2);
define("ERROR_INVALID_API_KEY",-3);

//result codes
define('RESULT_KEY', 'result:');
define("NO_TRIAL_LICENSE_FOUND", 10);
define('NTLF_URL_KEY','url:');
define('TRIAL_LICENSE_EXPIRED',11);
define('TRIAL_LICENSE_FILE_NOT_FOUND',12);
define('TRIAL_LICENSE_FOUND',13);
define('TLF_NUM_DAYS_LEFT_KEY','num_days_left:');
define('TLF_LICENSE_DATA_KEY','license_data:');

define("APIKEY", "4cd033c3a08b0818293411");

$products = array('jacket','arrayfire');

function getDays($date1, $date2)
{
    $date1 = explode('-', $date1);
    $date2 = explode('-', $date2);
    $date1 = gregoriantojd($date1[1], $date1[2], $date1[0]);
    $date2 = gregoriantojd($date2[1], $date2[2], $date2[0]);
    return $date1 - $date2;
}

if (!isset($_POST['hostid']) || !isset($_POST['product']) || !isset($_POST['apikey']))
{
    echo ERROR_KEY . ERROR_MISSING_PARAMS;
    exit();
}

$hostid = trim(mysql_escape_string($_POST['hostid']));
$product = trim(mysql_escape_string($_POST['product']));
$apikey = trim(mysql_escape_string($_POST['apikey']));

if (!in_array($product,$products))
{
    echo ERROR_KEY . ERROR_INVALID_PRODUCT;
    exit();
}

if ($apikey !== APIKEY)
{
    echo ERROR_KEY . ERROR_INVALID_API_KEY;
    exit();
}

//ok now we can start looking at the tables and search for the host id
$license = null;
$license_prefix = null;
if ($product === "jacket")
{
    $license = Mage::getModel('license/license');
    $license_prefix = 'license';
} else
{
    $license = Mage::getModel('licenselibjacket/license');
    $license_prefix = 'arrayfire';
}

$licenses = $license->getResourceCollection()->addFieldToFilter("host_id", $hostid)->addFieldToFilter("user_type", 'trial')->setOrder("maintenance_date");

if ($licenses == null || count($licenses) == 0)
{
    //the requested host id could not be found
    //indicate success and that no trial license was found
    echo ERROR_KEY . ERROR_SUCCESS . "\n";
    echo RESULT_KEY . NO_TRIAL_LICENSE_FOUND . "\n";
    echo NTLF_URL_KEY . Mage::getBaseUrl() . 'reg?d=' . urlencode(base64_encode($product . '_' . $hostid)) . "\n";
    exit();
} else
{
    //grab the first license since that would be the most recent license if there were more than 1
    $license = $licenses->getFirstItem();

    //calculate number of days left
    //if >= 0, then days are still left else no more days left for trial
    $num_days_left = getDays(date('y-m-d',$license->getMaintenanceDate()),date('y-m-d')) + 1;

    //first check if the license has expired
    if ($num_days_left < 0)
    {
        //license has expired
        echo ERROR_KEY . ERROR_SUCCESS . "\n";
        echo RESULT_KEY . TRIAL_LICENSE_EXPIRED;
        exit();
    }

    //ok seems like a good license file

    //TODO:  do some analytics on SF

    //now get the license file data
    $filename = $license_prefix . $license->getLicenseCode() . '.lic';
    if (!file_exists(BP . DS . '/license-downloads/' . $filename)) 
    {
        //create the license file as necessary
        $license->generateTrialLicense($license->getVersion());
    }

    $license_data = file_get_contents(BP . DS . '/license-downloads/' . $filename);

    if ($license_data === false)
    {
        //hmm, the data file couldn't be read, forget about it!
        echo ERROR_KEY . ERROR_SUCCESS . "\n";
        echo RESULT_KEY . TRIAL_LICENSE_FILE_NOT_FOUND;
        exit();        
    }

    echo ERROR_KEY . ERROR_SUCCESS . "\n";
    echo RESULT_KEY . TRIAL_LICENSE_FOUND . "\n";
    echo TLF_NUM_DAYS_LEFT_KEY . $num_days_left . "\n";
    echo TLF_LICENSE_DATA_KEY . "\n" . $license_data . "\n";
}


?>
