<?php
   /**
   * Gets included in download_arrayfire.phtml if linux OS is detected.
   */
   ?>

<div class="download_instructions_container">
  <div class="header">ArrayFire CUDA Linux Installation Instructions</div>
  <div class="links">
    <a href="#section_1">Installation</a><br>
    <a href="#section_2">Support</a><br>
    <a href="#section_3">ArrayFire Licensing</a>

  </div>
  <br><br>
  <div class="header">ArrayFire OpenCL Linux Installation Instructions</div>
  <div class="links">
    <a href="#section_4">Installation</a>
  </div>

  <div class="section" id="section_1">
    <div class="header">Installation</div>
     
    <table>
     <tr>
     <td>Unpack ArrayFire using unzip<br>
     </td>
     <td class="code_container">
     accelereyes$: unzip ArrayFire-linux-00907d.zip<br>
     Archive:  ArrayFire-linux-00a907d.zip<br>
     inflating: arrayfire/lib64/libaf.so<br>
     inflating: arrayfire/lib64/gactivate<br>
     inflating: arrayfire/lib64/libafGFX.so<br>
     inflating: arrayfire/lib64/libaf_fortran.so<br>
     .....<br>
     </td>
     </tr>
     <tr>
     <br>
     ArrayFire examples assume the CUDA Toolkit to be installed at <code>/usr/local/cuda</code>.
     If installed elsewhere, set the CUDA environment variable to the alternate location <code>(CUDA=/opt/software/cuda)</code> or
     modify the default variable setting in <code>/home/accelereyes/arrayfire/examples/common.mk</code>.
     <br><br>
     </tr>
     <tr>
     <td>ArrayFire includes many examples that demonstrates its features.
     For example, to build <code>examples/template</code>, navigate to the 
     template example directory and enter <code>make run</code>.
     </td>
     <td class="code_container">
     accelereyes$: cd arrayfire/examples/template<br>
     accelereyes$: pwd<br>
     /home/accelereyes/arrayfire/examples/template<br>
     accelereyes$: make run<br>
     g++  -Wall -Werror -I../../include -I/usr/local/cuda/include -O2 -DNDEBUG -lafGFX -lrt -L../../lib -laf  -L/usr/local/cuda/lib -lcuda -lcudart -lpthread -lstdc++ -Wl,-rpath,../../lib,-rpath,/home/accelereyes/arrayfire/lib,-rpath,/usr/local/cuda/lib  template.cpp   -o template<br>
     for F in template; do echo $F; ./${F} -; done<br>
     template<br>
     ArrayFire v1.0 (build 00a907d) by AccelerEyes (32-bit Linux)<br>
     License Type: Concurrent Network (27000@www.accelereyes.com)<br>
     Addons: none<br>
     CUDA toolkit 4.0, driver 270.41.19<br>
     GPU0 Tesla C2050 / C2070, 2688 MB, Compute 2.0 (single,double)<br>
     Display Device: GPU0 Tesla C2050 / C2070<br>
     Memory Usage: 2352 MB free (2688 MB total)<br>
     </td>
     </tr>
     <tr>
     <td>
     (Recommended) Set the AF_PATH environment variable to where you installed ArrayFire. Also add it to <code>~/.bashrc</code> for future sessions.
     </td>
     <td class="code_container">
     accelereyes $ export AF_PATH=/home/accelereyes/arrayfire<br>
     accelereyes $ echo export AF_PATH=/home/accelereyes/arrayfire >> ~/.bashrc<br>
     accelereyes $ echo $AF_PATH<br>
     /home/accelereyes/arrayfire<br>
     </td>
     </tr>
    </table>
  </div>

  <div class="section" id="section_2">
    <div class="header">Support</div>

    <table>
      <tr>
        <td>
          Online documentation for ArrayFire is available at <a href="http://www.accelereyes.com/arrayfire_cuda/"
          target="_blank">ArrayFire CUDA</a> page. 
          For additional assistance join the <a href="http://forums.accelereyes.com/forums/"
          target="_blank">ArrayFire Forums</a> discussion or
          contact <a href="mailto:support@accelereyes.com">support@accelereyes.com</a>.
        </td>
      </tr>
    </table>
  </div>

  <div class="section" id="section_3">
    <div class="header">ArrayFire Licensing</div>
    <table>
      <tr>
       <td>
       By default, ArrayFire authenticates for free using hosted license servers at www.accelereyes.com.<br><br>
       <a href="http://www.accelereyes.com/products/arrayfire_licensing">ArrayFire Pro</a> adds several features not found in the free version,
       including the ability to run offline, <a href="http://www.accelereyes.com/arrayfire_cuda/group__device__mat.htm">run multiple devices in parallel</a>,
       <a href="http://www.accelereyes.com/arrayfire_cuda/group__linalg__mat.htm">double-precision linear algebra</a>,
       <a href="http://www.accelereyes.com/arrayfire_cuda/group__sparse__mat.htm">sparse linear algebra</a>, and more.
       Use the <a href="https://www.accelereyes.com/customer/account/login">Manage Licenses</a> page to start a Pro trial
       or download a purchased license file.<br>
       Save the downloaded license file to <code>$HOME/arrayfire.lic</code> (or <code>$HOME/.arrayfire.lic</code> to make it a hidden file).
       <br><br>
       You can also save the license file to the same directory as your project executable.
       </td>
      </tr>
    </table>
  </div>


  <div class="section" id="section_4">
    <div class="header">ArrayFire OpenCL Installation</div>
    <br>

    <tr>
    <td class="info">ArrayFire OpenCL package contains the necessary OpenCL header files and dynamic libraries to link against.
     </tr>
     <br><br>
     <table>
     <tr>
     <td>
     Just unzip the package and navigate to the examples directory. Enter <code>make clean && make</code>.<br><br>After the build completes,
     export <code>arrayfire_ocl/bin</code> (bin64 on 64-bit Linux) to <code>$LD_LIBRARY_PATH</code>.
     <br><br>
     </td>
     <td class="code_container">
     accelereyes $ cd arrayfire_ocl/examples<br>
     accelereyes $ make clean && make<br>
     g++ -I../include -L../lib64 -Wl,-rpath=../lib64 -lafcl -LlibOpenCL.so.1 -LlibclAmdBlas.so.1 -LclAmdFft.Runtime.so.1.4.82 ../examples/helloworld.cpp -o ../bin64/helloworld<br><br>
     accelereyes $ export LD_LIBRARY_PATH=/home/accelereyes/arrayfire_ocl/:$LD_LIBRARY_PATH<br>
     </td>
     <tr>
     <td>
     Switch to <code>arrayfire_ocl/bin64</code> directory and
     enter <code>./hello_world</code> that displays the list of OpenCL devices found in the system.
     </td>
     <td class="code_container">
     accelereyes $ cd ../bin64<br>
     accelereyes $ ./hello_world<br>
     Arrayfire (OpenCL alpha)<br>
     Device0: Barts (in use)<br>
     Device1: Intel(R) Core(TM) i7-2600 CPU @ 3.40GHz<br>
     Device2: GeForce GTX 560<br>
     </td>
     </tr>
     </table>
     <br><br>
     <tr>
     Online documentation for ArrayFire OpenCL is available at <a href="http://www.accelereyes.com/arrayfire_opencl/">ArrayFire OpenCL</a> page.
     <strong>Make sure you have installed the OpenCL drivers and SDK for your hardware (
     <a href="http://developer.amd.com/sdks/AMDAPPSDK/downloads/Pages/default.aspx">AMD</a>,
     <a href="http://software.intel.com/en-us/articles/vcsource-tools-opencl-sdk/">Intel</a> or <a href="http://developer.nvidia.com/cuda-downloads">NVIDIA</a>).
     </strong>
     </td>
     </tr>
  </div>
  </div>

