<?php

class Accelereyes_Qla_IndexController extends Mage_Core_Controller_Front_Action
{

  public function postAction()
  {
    $post_data = $this->getRequest()->getParams();

    $qlaType = 'single';
    $qty = $post_data['single-qty'];

    if(!isset($qlaType)) {
      throw new Exception('No QLA Type specified');
    } else if($qlaType == 'single') {
      $sku = 'QLA-SINGLE';
      $prodId = 144;
    } else if ($qlaType == 'multi') {
      $sku = 'QLA-MULTI';
      $prodId = 130;
    } else if ($qlaType == 'site') {
      $sku = 'QLA-SITE';
      $prodId = 131;
    } else {
      throw new Exception('Invalid QLA Type specified.');
    }

    if(!isset($qty) || $qty < 0) {
      throw new Exception('Invalid QTY given');
    }

    $product = Mage::getModel('catalog/product')
      ->setStoreId(Mage::app()->getStore()->getId())
      ->load($prodId);

    $eventArgs = array(
    		       'product' => $product,
    		       'qty' => $qty,
    		       'request' => $this->getRequest(),
    		       );

    $cart = Mage::helper('checkout/cart')->getCart();

    Mage::dispatchEvent('checkout_cart_before_add', $eventArgs);
    $cart->addProduct($product, array('qty' => $qty));
    Mage::dispatchEvent('checkout_cart_after_add', $eventArgs);
    $cart->save();

    header("Location: " . Mage::getBaseUrl() . "checkout/cart/");
    exit;
  }

}