<?php

class Accelereyes_LicenseLibjacket_Model_License extends Mage_Core_Model_Abstract
{
    const MAX_HOSTID_CHANGES = 3;
    const TRIAL_LENGTH_DAYS = 15;

    // default port range in flex documentation is 27000 - 27009 starting at 27000
    const DEFAULT_CN_SERVER_PORT= '27000';
  
    // keys used for encrypt/decrypt
    const REMOTE_LICENSE_TO_KEY = "5555649d-40fe-49a2-a0f3-e24acb3e7d6a";
    const REMOTE_LICENSE_FROM_KEY = "ebc39b50-b93d-4c36-a8ab-3a9720551c0d";

    protected function _construct()
    {
        $this->_init('licenselibjacket/license');
    }

    public function getTrialLengthDays()
    {
      return self::TRIAL_LENGTH_DAYS;
    }

    public function getMaxAllowedHostChanges($license = null)
    {
      // students only get 2 host id change before having to contact sales
      if ($license != null && !empty($license['user_type'])){
        if ($license['user_type'] == "student") return 2;
      }
      // certain abusive users limited to 2
      if ($license != null && array_key_exists("customer_id", $license)){
        $limited_customers = array("3868", "3137");
        if (in_array($license['customer_id'], $limited_customers)){
          return 2;
        }
      }

      return self::MAX_HOSTID_CHANGES;
    }    

    /**
     * Overriding the save function to ensure a uuid always gets assigned no matter how
     * the license is created.
     */
    public function save(){
      $uuid = str_replace(".", "", uniqid("", true));

      if ($this->getExternalLicenseUuid() == NULL || strlen(trim($this->getExternalLicenseUuid())) < 1){
        $this->setExternalLicenseUuid($uuid);
      }

      parent::save();
    }

    public function getDefaultServerPort()
    {
      return self::DEFAULT_CN_SERVER_PORT;
    }

    public function update($updateMachine = false)
    {
      if ($updateMachine){
        $this->setMachineUpdate($this->getMachineUpdate()+1);        
      }
      $this->save();
    }

    public function generateLicenseCode()
    {

        $len = 8;
        $base='ABCDEFGHKLMNOPQRSTWXYZabcdefghjkmnpqrstwxyz123456789';
        $max=strlen($base)-1;
        $licenseCode='';
        mt_srand((double)microtime()*1000000);
        while (strlen($licenseCode)<$len+1)
            $licenseCode.=$base{mt_rand(0,$max)};

        return $licenseCode;

    }

    public function getLicenseByNumberAndCustomer($license_number, $customerId){
      $collection = $this->getResourceCollection()
        ->addFieldToFilter("customer_id", $customerId)
          ->addFieldToFilter("license_number", $license_number);

      if ($collection != null && count($collection) == 1){
        return $collection->getFirstItem();
      }

      return null;
    }

    public function getCustomerLicenses($customerId)
    {

        $collection = $this->getResourceCollection()
            ->addFieldToFilter('customer_id', $customerId);

        return $collection;

    }

    public function getCustomerConcurrentNetworkLicenses($customerId)
    {

        $collection = $this->getResourceCollection()
          ->addFieldToFilter('customer_id', $customerId);

        $concurrent = array();
        foreach($collection as $license){
          if ($license['cn'] > 0){
            $concurrent[] = $license;
          }
        }

        return $concurrent;
    }

    public function hasTrialLicense($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

                return 1;

            }

        }

        return 0;

    }

    public function hasUnexpiredTrialLicense($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

              return ($lic->getMaintenanceDate() > time()) ? 1 : 2;

            }

        }

        return 0;

    }

    public function getUnexpiredTrialLicenseNumber($customerId)
    {

    	$collection = $this->getResourceCollection()
	        ->addFieldToFilter('customer_id', $customerId);

    	foreach($collection as $lic)
        {

            if($lic->getUserType() == 'trial')
            {

              return ($lic->getMaintenanceDate() > time()) 
                ? $lic->getLicenseNumber() . ';' . date('F j, Y', $lic->getMaintenanceDate()) : 0;

            }

        }

        return 0;

    }

    public function generateFlexLicense($version)
    {
      if(!$this->getCn() || $this->getCn() < 1)
      {
        $this->createDesignatedComputerLicenseTemplate($version);
      }
      else
      {
        $this->createConcurrentNetworkLicenseTemplate($version);
      }

      if (version_compare($version, "1.0") >= 0){
        $licenseFile = 'arrayfire' . $this->getLicenseCode() . '.lic';
        
        $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt13  ../license-downloads/" . $licenseFile;
        exec($cmd);	
      }
      else{
        $licenseFile = 'arrayfire' . $this->getLicenseCode() . '.lic';
        
        $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt  ../license-downloads/" . $licenseFile;
        exec($cmd);
      }
    }

    public function generateTrialLicense($version)
    {

        $this->createTrialTemplate($version);

	if (version_compare($version, "1.0") >= 0){
	  $licenseFile = 'arrayfire' . $this->getLicenseCode() . '.lic';
          $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt13 ../license-downloads/" . $licenseFile;
          exec($cmd);
	}
	else{
          $licenseFile = 'arrayfire' . $this->getLicenseCode() . '.lic';
          $cmd = "cd " . Mage::getBaseDir() . "/cgi-bin; ./lmcrypt  ../license-downloads/" . $licenseFile;
          exec($cmd);
        }
    }

    public function createConcurrentNetworkLicenseTemplate($version)
    {
      $mgl = $this->getMgl();
      $dla = $this->getJla();
      $sla = $this->getSla();
      $host_name = $this->getHostName();
      $host_port = $this->getHostPort();
      $concurrent_network_nodes = $this->getCn();
      $phone = ($this->getSupportDate() == 0 ? 0 : 1);
      $expire = $this->expirationDate();

      $server_line = "SERVER " . $host_name . " " . $this->getHostId() . " " . $host_port;
      $vendor_line = "VENDOR jacket";

      $features = $this->buildFeatureLine("af_base", $version, $expire, $concurrent_network_nodes);
      if ($mgl > 0) $features .= $this->buildFeatureLine("mgl", $version, $expire, $mgl);
      if ($dla > 0) $features .= $this->buildFeatureLine("dla", $version, $expire, $dla);
      if ($sla > 0) $features .= $this->buildFeatureLine("sla", $version, $expire, $sla);

      $license_file_content =
        $server_line . "\n" .
        $vendor_line . "\n" .
        $features;

      $handle = fopen($this->licenseFilePath(), "w");

      fwrite($handle, $license_file_content);
      fclose($handle);
    }

    public function createDesignatedComputerLicenseTemplate($version)
    {
      $mgl = $this->getMgl();
      $dla = $this->getJla();
      $sla = $this->getSla();
      $phone = ($this->getSupportDate() == 0 ? 0 : 1);      
      $expire = $this->expirationDate();

      $features = $this->buildFeatureLine("af_base", $version, $expire, "uncounted", $this->getHostId());
      if ($mgl > 1) $features .= $this->buildFeatureLine("mgl" . $mgl, $version, $expire, "uncounted", $this->getHostId());
      if ($dla > 0) $features .= $this->buildFeatureLine("dla", $version, $expire, "uncounted", $this->getHostId());
      if ($sla > 0) $features .= $this->buildFeatureLine("sla", $version, $expire, "uncounted", $this->getHostId());

      $handle = fopen($this->licenseFilePath(), "w");

      fwrite($handle, $features);
      fclose($handle);
    }

    public function createTrialTemplate($version)
    {
      $expire = strtolower(date("d-M-Y", $this->getMaintenanceDate()));

      // hard coded because this is a trial, fully loaded Designated Computer license
      $features = $this->buildFeatureLine("af_base", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("mgl4", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("dla", $version, $expire, "uncounted", "ANY");
      $features .= $this->buildFeatureLine("sla", $version, $expire, "uncounted", "ANY");

      $handle = fopen($this->licenseFilePath(), "w");
      fwrite($handle, $features);
      fclose($handle);
    }

    private function licenseFilePath(){
      return Mage::getBaseDir() . "/license-downloads/arrayfire" . $this->getLicenseCode() . ".lic";
    }
 
    private function expirationDate(){
      $expire = "permanent";

      if ($this->getExpirationDate() != null && $this->getExpirationDate() > 0){
        $expire = strtolower(date("d-M-Y", $this->getExpirationDate()));
      }
      else if (($this->getUserType() == "student") || ($this->getUserType() == "free")){
        $expire = strtolower(date("d-M-Y", $this->getMaintenanceDate()));
      }

      return $expire;
    }

    private function buildFeatureLine($feature, $version, $expire, $count, $hostId=""){
      if ($hostId != "ANY" && $hostId != ""){
        // node locked licenses need VDH component regardless of version
        $hostId = "VDH=" . $hostId;
      }

      $version = $this->convertVersionString($version);

      if ($feature !== 'af_base') {
      	 $feature = 'af_' . $feature;
      }

      $feature_line = "FEATURE " . $feature . " jacket " . $version . " " . $expire . " " . $count;
      $feature_line = ($hostId != "") ? $feature_line . " TS_OK HOSTID=" . $hostId : $feature_line;
      $feature_line .= " SIGN=0\n";

      return $feature_line;
    }

    private function convertVersionString($version){
      // from now on this should pick everything up.
      // Some examples:
      //    1.4.0 => 1.40
      //    1.4.3 => 1.40
      if (version_compare($version, "1.0.0") > 0){
        return substr_replace($version, "0", strrpos($version, "."));
      }

      switch($version){
      }

      return $version;
    }
}