<?php

class Accelereyes_LicenseLibjacket_Block_Admin_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{

    protected function _prepareForm()
    {

        $license = Mage::registry('frozen_licenselibjacket');

        $data = $license->getData();

        $customerId = $license->getCustomerId();
        $customer = Mage::getModel('customer/customer')->load($customerId);

         $form = new Varien_Data_Form(array(
            'id'        => 'edit_form',
            'action'    => $this->getUrl('*/*/save', array('id' =>
                                    $this->getRequest()->getParam('id'))),
            'method'    => 'post'
        ));

        // common fieldset that holds core values shared by all licenses
        $fieldset = $form->addFieldset('edit_license', array('legend' =>
                          Mage::helper('licenselibjacket')->__('License Details for
                          %s', $customer->getName())));
        
        $featureFieldset = $form->addFieldset('edit_license_feature', array('legend' => Mage::helper('licenselibjacket')->__('License Features')));

	$customerFieldset = $form->addFieldset('edit_license_customer', array('legend' => Mage::helper('licenselibjacket')->__('Associated Customer *** Be Careful Changing This ***')));
        

        $cnFieldset = $form->addFieldset('edit_license_concurrent', array('legend' => Mage::helper('licenselibjacket')->__('Concurrent Network Specific Configuration')));

        $fieldset->addField('purchase_date', 'date', array(
            'name'          => 'purchase_date',
            'title'         => Mage::helper('licenselibjacket')->__('Purchase Date'),
            'label'         => Mage::helper('licenselibjacket')->__('Purchase Date'),
            'align'         => 'right',
            'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
            'required'      => 'true',
        ));

        $fieldset->addField('maintenance_date', 'date', array(
            'name'          => 'maintenance_date',
            'title'         => Mage::helper('licenselibjacket')->__('Maintenance/Trial Expiration'),
            'label'         => Mage::helper('licenselibjacket')->__('Maintenance/Trial Expiration'),
            'align'         => 'right',
            'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
            'required'      => 'true',
        ));

        $fieldset->addField('support_date', 'date', array(
            'name'          => 'support_date',
            'title'         => Mage::helper('licenselibjacket')->__('Support Expiration'),
            'label'         => Mage::helper('licenselibjacket')->__('Support Expiration'),
            'align'         => 'right',
            'image'         => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
            'format'        => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
        ));

        $fieldset->addField('user_type', 'select', array(
                              'name'          => 'user_type',
                              'title'         => Mage::helper('licenselibjacket')->__('License Type'),
                              'label'         => Mage::helper('licenselibjacket')->__('License Type'),
                              'align'         => 'right',
                              'width'         => '25',
                              'options'       => $this->_getTypeArray($customerId),
                              'required'      => 'true',
                            ));

        $fieldset->addField('license_code', 'text', array(
                              'name'          => 'license_code',
                              'title'         => Mage::helper('licenselibjacket')->__('License Code'),
                              'label'         => Mage::helper('licenselibjacket')->__('License Code'),
                              'align'         => 'right',
                              'maxlength'     => '100',
                              'required'      => false,
                              'value'         => '<a href="http://www.google.com">Hey Mom!</a>',
                            ));

        $fieldset->addField('order_number', 'text', array(
                              'name'          => 'order_number',
                              'title'         => Mage::helper('licenselibjacket')->__('Order Number'),
                              'label'         => Mage::helper('licenselibjacket')->__('Order Number'),
                              'align'         => 'right',
                              'maxlength'     => '100',
                              'required'      => false,
                              'value'         => $license->getOrderNumber(),
                            ));

        $fieldset->addField('host_id', 'text', array(
                              'name'          => 'host_id',
                              'title'         => Mage::helper('licenselibjacket')->__('Host ID'),
                              'label'         => Mage::helper('licenselibjacket')->__('Host ID'),
                              'align'         => 'right',
                              'maxlength'     => '12',
                              'required'      => false,
                              'value'         => $license->getHostId(),
                            ));

        $fieldset->addField('machine_update', 'text', array(
            'name'          => 'machine_update',
            'title'         => Mage::helper('licenselibjacket')->__('Host ID Updates'),
            'label'         => Mage::helper('licenselibjacket')->__('Host ID Updates'),
            'align'         => 'right',
            'maxlength'     => '10',
            'required'      => false,
            'style'         => '25px',
            'value'         => $license->getMachineUpdate(),
        ));

        $fieldset->addField('expiration_date', 'date', array(
                              'name' => 'expiration_date',
                              'title' => Mage::helper('licenselibjacket')->__('Expiration Date'),
                              'label' => Mage::helper('licenselibjacket')->__('Expiration Date'),
                              'align' => 'right',
                              'image' => Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_SKIN) . '/adminhtml/default/default/images/grid-cal.gif',
                              'format' => Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_MEDIUM),
                            ));

        $customerFieldset->addField('customer_id', 'text', array(
	    'name'          => 'customer_id',
	    'title'	    => Mage::helper('licenselibjacket')->__('Customer ID'),
	    'label'	    => Mage::helper('licenselibjacket')->__('Customer ID'),
	    'style'  	    => 'width:100px'
	));			    

        $fieldset->addField('reseller_code', 'text', array(
	    'name'          => 'reseller_code',
	    'title'	    => Mage::helper('licenselibjacket')->__('Reseller Code'),
	    'label'	    => Mage::helper('licenselibjacket')->__('Reseller Code'),
	    'style'  	    => 'width:100px'
	));			    

        $featureFieldset->addField('mgl', 'text', array(
                                     'name' => 'mgl',
                                     'title' => Mage::helper('licenselibjacket')->__('MGL'),
                                     'label' => Mage::helper('licenselibjacket')->__('MGL'),
                                     'align' => 'right',
                                     'style' => 'width:25px',
                                     'value' => $license->getMgl()
                                   ));

        $featureFieldset->addField('jla', 'text', array(
                                     'name'          => 'jla',
                                     'title'         => Mage::helper('licenselibjacket')->__('DLA'),
                                     'label'         => Mage::helper('licenselibjacket')->__('DLA'),
                                     'align'         => 'right',
                                     'style'         => 'width:25px',
                                     'value'       => $license->getJla(),
                                   ));

        $featureFieldset->addField('sla', 'text', array(
                                     'name'          => 'sla',
                                     'title'         => Mage::helper('licenselibjacket')->__('SLA'),
                                     'label'         => Mage::helper('licenselibjacket')->__('SLA'),
                                     'align'         => 'right',
                                     'style'         => 'width:25px',
                                     'value'       => $license->getSla(),
                                   ));

        $featureFieldset->addField('hpc', 'text', array(
                                     'name' => 'hpc',
                                     'title' => Mage::helper('licenselibjacket')->__('HPC'),
                                     'label' => Mage::helper('licenselibjacket')->__('HPC'),
                                     'align' => 'right',
                                     'style' => 'width:25px',
                                     'value' => $license->getHpc()
                                   ));

        $cnFieldset->addField('host_name', 'text', array(
                              'name'          => 'host_name',
                              'title'         => Mage::helper('licenselibjacket')->__('Host Name'),
                              'label'         => Mage::helper('licenselibjacket')->__('Host Name'),
                              'align'         => 'right',
                              'maxlength'     => '100',
                              'required'      => false,
                              'style' => 'width:150px',
                              'value'         => $license->getHostName(),
                            ));

        $cnFieldset->addField('host_port', 'text', array(
                              'name'          => 'host_port',
                              'title'         => Mage::helper('licenselibjacket')->__('Host Port'),
                              'label'         => Mage::helper('licenselibjacket')->__('Host Port'),
                              'align'         => 'right',
                              'maxlength'     => '100',
                              'required'      => false,
                              'style' => 'width:50px',
                              'value'         => $license->getHostPort(),
                            ));

        $cnFieldset->addField('cn', 'text', array(
                              'name'          => 'cn',
                              'title'         => Mage::helper('licenselibjacket')->__('CN Nodes'),
                              'label'         => Mage::helper('licenselibjacket')->__('CN Nodes'),
                              'align'         => 'right',
                              'style'         => 'width: 25px',
                              'value'       => $license->getCn(),
                            ));


        $form->setUseContainer(true);
        $form->setValues($data);
        $this->setForm($form);
        return parent::_prepareForm();
    }

    protected function _getCustomerName($customerId)
    {

        return Mage::getModel('customer/customer')->load($customerId)->getName();

    }

    protected function _getTypeArray($customerId)
    {

        $result = array();

        $customer = Mage::getModel('customer/customer')->load($customerId);
        switch($customer->getGroupId())
        {
            case 1:
                $result['commercial'] = 'Individual / Commercial';
                break;
            case 3:
                $result['government'] = 'Government / Research';
                break;
            case 2:
                $result['academic'] = 'Academic';
                break;
            case 4:
                $result['student'] = 'Student';
                break;
         }

         $result['trial'] = 'Trial';
         $result['free'] = 'Free';

         return $result;

    }

}
