<?php
require_once("CustomPurchaseHelpers.php");

class Accelereyes_License_CartController extends Mage_Core_Controller_Front_Action
{ 
  private static function featureAmount($data, $feature){
    if (array_key_exists($feature, $data)){
      if ($data[$feature] === "on"){
        return 1;
      }
      return $data[$feature];
    }
    
    return 0;
  }
  
  /**
   * Logic for adding a feature to an upgrade/addon feature.
   * Modifies $pids and $prices params.
   * @returns The cost of that feature
   */
  private static function processFeature(&$pids, &$prices, $postData, $postParam, $newPid, $pricePremium){
    if (self::featureAmount($postData, $postParam) > 0){
      $pids[$newPid] = self::featureAmount($postData, $postParam);
      $prices[$newPid] = CustomPurchaseHelpers::tierPrice($newPid) * $pricePremium;
      $subTotal = $prices[$newPid] * $pids[$newPid];
      if ($subTotal > 0) return $subTotal;
    }
     
    return 0;
  }

  private function cancelIfInvalid($post_data, $feature, $error_message, $allowed_amount = 1){
    if (array_key_exists($feature, $post_data) && $post_data[$feature] > $allowed_amount){
      Mage::getSingleton('checkout/session')->addError($error_message);
      header("Location: /licenses");
      exit();
    }
  }
  
  public function addAction()
  {

    $post_data = $this->getRequest()->getPost();
    $catalogModel = Mage::getModel('catalog/product');
    
    if (array_key_exists('upgrade_license_number', $post_data)
          && strlen($post_data['upgrade_license_number']) > 0){
      // customer has placed an upgrade order for an existing license
      
      $licenseNumber = $post_data['upgrade_license_number'];
      
      $customerId = Mage::getModel('customer/session')->getCustomerId();
      $existingLicense = Mage::getModel('license/license')
          ->getLicenseByNumberAndCustomer($licenseNumber, $customerId);
      if ($existingLicense == null){
        // should never happen unless someone is URL hacking
        echo("Invalid Request");
        exit();
      }
      
      // recalculate the price from scratch ignoring what actually was submitted so people
      // can't modify the POST data
      $pricePremium = CustomPurchaseHelpers::calculatePricePremium($existingLicense);
      $originalLicensePrice = CustomPurchaseHelpers::originalPrice($existingLicense);
      $subTotal = 0;
      
      $products = array(
          'jla', 'sla', 'sdk', 'jmc', 'mgl-qty', 'sms', 'phone'
      );
      
      $pids = array();
      $customPrices = array();
      
      // calculate pricing for new features and add them to order
      $subTotal += self::processFeature($pids, $customPrices, $post_data, "jla", 
          CustomPurchaseHelpers::PID_DLA, $pricePremium);
      $subTotal += self::processFeature($pids, $customPrices, $post_data, "sla", 
          CustomPurchaseHelpers::PID_SLA, $pricePremium);
      $subTotal += self::processFeature($pids, $customPrices, $post_data, "sdk", 
          CustomPurchaseHelpers::PID_SDK, $pricePremium);
      $subTotal += self::processFeature($pids, $customPrices, $post_data, "jmc", 
          CustomPurchaseHelpers::PID_JMC, $pricePremium);
      $subTotal += self::processFeature($pids, $customPrices, $post_data, "mgl-qty", 
          CustomPurchaseHelpers::PID_MGL, $pricePremium);

      // now calculate SMS + Phone cost and add those
      $maintenanceYears = CustomPurchaseHelpers::maintenanceYearsRequired($existingLicense);
      if (self::featureAmount($post_data, "sms") > 0){
        if (CustomPurchaseHelpers::isStudentUser()){
          // students pay full license price for each 1 year extension
          $pids[CustomPurchaseHelpers::PID_SMS_UPGRADE] = 1;
          $customPrices[CustomPurchaseHelpers::PID_SMS_UPGRADE] = $originalLicensePrice * $maintenanceYears; 
        }
        else{
          $pids[CustomPurchaseHelpers::PID_SMS_UPGRADE] = 1;
          $customPrices[CustomPurchaseHelpers::PID_SMS_UPGRADE] = ($subTotal + $originalLicensePrice) * .1 * $maintenanceYears;
        }
      }
      
      if (self::featureAmount($post_data, "phone") > 0){
        $pids[CustomPurchaseHelpers::PID_PHONE_UPGRADE] = 1;
        $customPrices[CustomPurchaseHelpers::PID_PHONE_UPGRADE] = ($subTotal + $originalLicensePrice) * .2;
      }
      
      $this->addToCart($pids, $post_data['upgrade_license_number'], $customPrices);
    }
    else{
      // customer has ordered a new license or licenses
      $products = array(
        'dev-bundle-qty',
        'five-seats-qty',
        'ten-seats-qty',
        'base-qty',
        'jla-qty',
        'sla-qty',
        'sdk-qty',
        'jmc-qty',
        'mgl-qty',
        'hpc-qty',
        'sms',
        'phone',
        'cn'
        );

      $sms = 0;
      $phone = 0;
      $cn = 0;

      // For security, sanitizing POST data and putting it in a new container.
      // There's probably a righter way to do this.
      foreach($products as $product)
      {
        $key = str_replace('-', '_', $product);
        if(isset($post_data[$product]))
        {
          $$key = (int) htmlspecialchars($post_data[$product], ENT_QUOTES);
        }
        else { $$key = 0; }
      }

      /* Make sure the pIds reflect the id of their respective products. */
      $pIds = array();
      $pIds[116] = $dev_bundle_qty;
      $pIds[117] = $five_seats_qty;
      $pIds[118] = $ten_seats_qty;
      $pIds[105] = $base_qty;
      $pIds[101] = $jla_qty;
      $pIds[146] = $sla_qty;
      $pIds[106] = $sdk_qty;
      $pIds[107] = $jmc_qty;
      $pIds[108] = $mgl_qty;
      $pIds[109] = $hpc_qty;

      /* Add the Maintenance Products */
      $pIds[110] = ($sms) ? $base_qty : 0;
      $pIds[111] = ($sms) ? $jla_qty : 0;
      $pIds[147] = ($sms) ? $sla_qty : 0;
      $pIds[112] = ($sms) ? $sdk_qty : 0;
      $pIds[113] = ($sms) ? $jmc_qty : 0;
      $pIds[114] = ($sms) ? $mgl_qty : 0;
      $pIds[115] = ($sms) ? $hpc_qty : 0;
      $pIds[130] = ($sms) ? $dev_bundle_qty : 0;
      $pIds[133] = ($sms) ? $five_seats_qty : 0;
      $pIds[136] = ($sms) ? $ten_seats_qty : 0;

      /* Add the Phone Support Products  */
      $pIds[119] = ($phone) ? $base_qty : 0;
      $pIds[120] = ($phone) ? $jla_qty : 0;
      $pIds[148] = ($phone) ? $sla_qty : 0;
      $pIds[121] = ($phone) ? $sdk_qty : 0;
      $pIds[122] = ($phone) ? $jmc_qty : 0;
      $pIds[123] = ($phone) ? $mgl_qty : 0;
      $pIds[124] = ($phone) ? $hpc_qty : 0;
      $pIds[131] = ($phone) ? $dev_bundle_qty : 0;
      $pIds[134] = ($phone) ? $five_seats_qty : 0;
      $pIds[137] = ($phone) ? $ten_seats_qty : 0;

      /* Add the CNL Products  */
      $pIds[103] = ($cn) ? $base_qty : 0;
      $pIds[125] = ($cn) ? $jla_qty : 0;
      $pIds[149] = ($cn) ? $sla_qty : 0;
      $pIds[126] = ($cn) ? $sdk_qty : 0;
      $pIds[127] = ($cn) ? $jmc_qty : 0;
      $pIds[128] = ($cn) ? $mgl_qty : 0;
      $pIds[129] = ($cn) ? $hpc_qty : 0;
      $pIds[132] = ($cn) ? $dev_bundle_qty : 0;
      $pIds[135] = ($cn) ? $five_seats_qty : 0;
      $pIds[138] = ($cn) ? $ten_seats_qty : 0;

      $licenseOrderModel = Mage::getModel('license/order');

      $this->addToCart($pIds);

      /**
       * Temporary
       */	

      // customer has ordered a new license or licenses
      $products = array(
        'afp02-qty',
        'afp04-qty',
        'afp08-qty',
        'phone',
        'cn'
        );

      $phone = 0;
      $cn = 0;

      // For security, sanitizing POST data and putting it in a new container.
      // There's probably a righter way to do this.
      foreach($products as $product)
      {
        $key = str_replace('-', '_', $product);
        if(isset($post_data['af-pro-' . $product]))
        {
          $$key = (int) htmlspecialchars($post_data['af-pro-' . $product], ENT_QUOTES);
        }
        else { $$key = 0; }
      }

      /* Make sure the pIds reflect the id of their respective products. */
      $pIds = array();
      if ($cn > 0)
      {
          //krunal - unimplemetend
          /* $pIds[$catalogModel->getIdBySku('AF-PRO-02GPU-CN')] = ($cn) ? $afp02_qty : 0; */
          /* $pIds[$catalogModel->getIdBySku('AF-PRO-04GPU-CN')] = ($cn) ? $afp04_qty : 0; */
          /* $pIds[$catalogModel->getIdBySku('AF-PRO-08GPU-CN')] = ($cn) ? $afp08_qty : 0; */

          /* $pIds[$catalogModel->getIdBySku('AF-PRO-02GPU-CN-PHONE')] = ($phone) ? $afp02_qty : 0; */
          /* $pIds[$catalogModel->getIdBySku('AF-PRO-04GPU-CN-PHONE')] = ($phone) ? $afp04_qty : 0; */
          /* $pIds[$catalogModel->getIdBySku('AF-PRO-08GPU-CN-PHONE')] = ($phone) ? $afp08_qty : 0; */
      } else
      {
          $pIds[$catalogModel->getIdBySku('AF-PRO-02GPU-PER')]  = $afp02_qty;
          $pIds[$catalogModel->getIdBySku('AF-PRO-04GPU-PER')]  = $afp04_qty;
          $pIds[$catalogModel->getIdBySku('AF-PRO-08GPU-PER')]  = $afp08_qty;         

          $pIds[$catalogModel->getIdBySku('AF-PRO-02GPU-PHONE')] = ($phone) ? $afp02_qty : 0;
          $pIds[$catalogModel->getIdBySku('AF-PRO-04GPU-PHONE')] = ($phone) ? $afp04_qty : 0;
          $pIds[$catalogModel->getIdBySku('AF-PRO-08GPU-PHONE')] = ($phone) ? $afp08_qty : 0;
      }

      $licenseOrderModel = Mage::getModel('licenselibjacket/order');

      $this->addToCart($pIds);
    }

    //$this->_forward('add','cart','licenseLibjacket', $post_data);
    header("Location: " . Mage::getBaseUrl() . "checkout/cart/");
    exit();
  }

  public function addstudentAction()
  {

    $post_data = $this->getRequest()->getPost();

    $products = array(
      'base-qty', 'mgl-qty', 'jla-qty', 'sla-qty', 'sdk-qty'
    );

    $this->cancelIfInvalid($post_data, "base-qty", "Students can only purchase 1 Jacket license.");
    $this->cancelIfInvalid($post_data, "jla-qty", "Students can only purchase 1 DLA addon.");
    $this->cancelIfInvalid($post_data, "sla-qty", "Students can only purchase 1 SLA addon.");
    $this->cancelIfInvalid($post_data, "sdk-qty", "Students can only purchase 1 SDK addon.");
    $this->cancelIfInvalid($post_data, "jmc-qty", "Students cannot purchase JMC addons.", 0);
    $this->cancelIfInvalid($post_data, "mgl-qty", "Students cannot purchase more than 16 MGL.", 16);
    $this->cancelIfInvalid($post_data, "hpc-qty", "Students cannot purchase HPC addons.", 0);
    $this->cancelIfInvalid($post_data, "cn-qty", "Students cannot purchase CN licenses.", 0);

    // For security, sanitizing POST data and putting it in a new container.
    // There's probably a righter way to do this.
    foreach($products as $product)
    {
      $key = str_replace('-', '_', $product);
      if(isset($post_data[$product]))
      {
        $$key = (int) htmlspecialchars($post_data[$product], ENT_QUOTES);
      }
      else { $$key = 0; }
    }

    /* Make sure the pIds reflect the id of their respective products. */
    $pIds = array();
    $pIds[105] = $base_qty;
    $pIds[101] = $jla_qty;
    $pIds[146] = $sla_qty;
    $pIds[106] = $sdk_qty;
    $pIds[108] = $mgl_qty;

    $licenseOrderModel = Mage::getModel('license/order');

    $this->addToCart($pIds);

    header("Location: " . Mage::getBaseUrl() . "checkout/cart/");
    exit();
  }

  /*
   * Joe, I realize this method is huge.  I plan to break it down into smaller chunks soon.
   */
  public function pdfAction()
  {
    $productModel = Mage::getModel('catalog/product')
      ->setStoreId(Mage::app()->getStore()->getId());
    $storeModel = Mage::getModel('core/store');
    $pdf = new Zend_Pdf();
    $pdfPage= new Zend_Pdf_Page(Zend_Pdf_Page::SIZE_A4);
    
    $width = $pdfPage->getWidth();
    $height = $pdfPage->getHeight();
    
    $colorBlack = new Zend_Pdf_Color_GrayScale(0.0);
    $colorJacketYellow = new Zend_Pdf_Color_Html('#ffd10f');
    $font = Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_TIMES);
    $boldFont = Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_TIMES_BOLD);

    /** Draw the logo **/
    $logo = Zend_Pdf_Image::imageWithPath($this->currDir() . '/pdf/accelereyes_logo.png');
    $pdfPage->drawImage($logo, 15 , $height-75, 160, $height-15);

    /** Write the address info **/
    $spacing = 15;
    $offset = 22;
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText('75 5th St. NW Suite 204', 175, $height-$offset);
    $pdfPage->drawText('Atlanta, GA 30308', 175, $height - $offset - $spacing);
    $pdfPage->drawText('USA', 175, $height - $offset - $spacing*2);
    $pdfPage->drawText('T: 800-570-1941  F:678-303-3409', 175, $height - $offset - $spacing*3);

    /** Write the "Quote" header **/
    $pdfPage->setFont($font, 36);
    $pdfPage->drawText('QUOTE', 450, $height-40);

    /** Write the date **/
    $pdfPage->setFont($boldFont, 12);
    $pdfPage->drawText('Date: ', 450, $height-65);
    $pdfPage->setFont($font, 12);
    $pdfPage->drawText(date('M d, Y', time()), 485,$height-65);

    /** Draw the Rectangles for the grid **/
    $pdfPage->setFillColor($colorJacketYellow);
    $pdfPage->drawRectangle(15, $height-80, $width-15, $height-95);
    $pdfPage->drawRectangle(15, $height-95, 45, $height-110);
    $pdfPage->drawRectangle(45, $height-95, 130, $height-110);
    $pdfPage->drawRectangle(130, $height-95, 380, $height-110);
    $pdfPage->drawRectangle(380, $height-95, 450, $height-110);
    $pdfPage->drawRectangle(450, $height-95, 520, $height-110);
    $pdfPage->drawRectangle(520, $height-95, $width-15, $height-110);

    /** Populate the grid boxes **/
    $pdfPage->setFont($font, 12);
    $pdfPage->setFillColor($colorBlack);
    $pdfPage->drawText('Quote Valid for 30 Days', $width-145, $height-92);
    $pdfPage->drawText('Qty', 19, $height-107);
    $pdfPage->drawText('SKU', 75, $height-107);
    $pdfPage->drawText('Description', 230, $height-107);
    $pdfPage->drawText('List Price', 389, $height-107);
    $pdfPage->drawText('Unit Price', 459, $height-107);
    $pdfPage->drawText('Ext. Price', 526, $height-107);

    $post_data = $this->getRequest()->getPost();

    $products = array(
      'dev-bundle-qty',
      'five-seats-qty',
      'ten-seats-qty',
      'base-qty',
      'jla-qty',
      'sla-qty',
      'sdk-qty',
      'jmc-qty',
      'mgl-qty',
      'hpc-qty',
      'sms',
      'phone',
      'cn'
    );

    $sms = 0;
    $phone = 0;
    $cn = 0;

    foreach($products as $product)
    {
      $key = str_replace('-', '_', $product);
      if(isset($post_data[$product]))
      {
        $$key = rand(0,3);//(int) htmlspecialchars($post_data[$product], ENT_QUOTES);
      }
      else { $$key = rand(0,3); }//0; }
    }

    /* Make sure the pIds reflect the id of their respective products. */
    $pIds = array();
    $pIds[116] = $dev_bundle_qty;
    $pIds[117] = $five_seats_qty;
    $pIds[118] = $ten_seats_qty;
    $pIds[105] = $base_qty;
    $pIds[101] = $jla_qty;
    $pIds[146] = $sla_qty;
    $pIds[106] = $sdk_qty;
    $pIds[107] = $jmc_qty;
    $pIds[108] = $mgl_qty;
    $pIds[109] = $hpc_qty;

    $pdfPage->setFont($font, 8);
    $currentY = $height - 125;
    $maxDescLength = 65;
    $columnTotal = 0;

    foreach($pIds as $pId => $qty)
    {
//      if($qty <= 0) { continue; }
      $product = $productModel
        ->load($pId);
      $name = $product->getName();
      $sku = $product->getSku();
      $desc = $product->getDescription();
      $desc = explode(' ', $desc);
      $price = $product->getPrice();
      $tierPrice = $product->getTierPrice('price');
      $total = $qty * $tierPrice;
      $columnTotal = $columnTotal + $total;
      $pdfPage->drawText($qty, 25, $currentY);
      $pdfPage->drawText($sku, 55, $currentY);
      $pdfPage->drawText(strip_tags($storeModel->formatPrice($price)), 395, $currentY);
      $pdfPage->drawText(strip_tags($storeModel->formatPrice($tierPrice)), 465, $currentY);
      $pdfPage->drawText(strip_tags($storeModel->formatPrice($total)), 530, $currentY);

      $currLine = '';
      /** Quick and dirty Word Wrap **/
      foreach($desc as $word)
      {
        $word = strip_tags($word);
        if($word == '') { continue; }
        if(strlen($currLine) + strlen($word) > $maxDescLength)
        {
          $pdfPage->drawText($currLine, 140, $currentY);
          $currLine = $word;
          $currentY -= 15;
        }
        else
        {
          $currLine = $currLine . ' ' . $word;
        }
      }
      $pdfPage->drawText($currLine, 140, $currentY);
      $currentY -= 20;
    }

    /** Draw total box **/
    $pdfPage->setFillColor($colorJacketYellow);
    $pdfPage->setFont($boldFont, 14);
    $pdfPage->drawLine(35, $currentY, 400, $currentY);
    $pdfPage->drawRectangle(425, $currentY, $width-15, $currentY-20);

    /** Draw Total  **/
    $pdfPage->setFillColor($colorBlack);
    $pdfPage->drawText('Total:      ' . strip_tags($storeModel->formatPrice($columnTotal)), 445, $currentY-15); 

    /** Draw Footer  **/
    $currentY = 130;
    $pdfPage->drawLine(15, $currentY, $width-15, $currentY);
    $currentY = $currentY - 10;

    $footerText = array(
      'Purchase Order  (To be completed by the customer)',
      'Accept     (By checking here, you argee to purchase the items listed in this quote by one of the approved methods of payment given below)',
      'Payment Information',
      'Debit/Credit Card          Visa          MasterCard          Discovery          American Express',
      'Card Number                                                               Expiration Date:                       Security Code:',
      '',
      'Check/Money Order',
      ' - Make your check or money order payable to AccelerEyes LLC. - Write the Quote Number from this form on the check.',
      ' - Mail your payment along with this purchase order form to AccelerEyes LLC, address shown above.',
      'Wire Transfer',
      ' - Use the following information for the wire transfer to AccelerEyes Silicon Valley Bank account.',
      'Routing No: 121140399 Account No: 3300702805 SWIFT Code: SVBKUS6S (International Wires Only)',
      ' - Bank Address: Silicon Valley Bank, 3003 Tasman Drive, Santa Clara, CA, 95054, USA',
      ' - Send an email to sales@accelereyes.com conifrming payment amount and date with this form attached.'
    );

    $pdfPage->setFont($boldFont, 8);
    foreach($footerText as $line)
    {
      $pdfPage->drawText($line, 16, $currentY);
      $currentY -= 10;
    }

    $pdf->pages[] = $pdfPage;
    $pdfData = $pdf->render();
    header("Conent-Disposition: inline; filename=AccelerEyes_Jacket_Quote.pdf");
    header("Content-type: application/x-pdf");
    echo $pdfData;
    exit();
  }

  /**
   * Adds to the cart the products in the associative array $products.
   * @param products The products to add to the quote/cart
   * @param licenseNumber Optional license number to which items should be added
   *        if they do end up getting purchased
   * @param customPrices Optional mapping from pid to a custom price.  
   */
  private function addToCart($products, $licenseNumber = null, $customPrices = null) {

    foreach($products as $pId=>$qty)
    {

      try {
        $cart = Mage::helper('checkout/cart')->getCart();
        
        if($qty <= 0){ continue; }

        $product = Mage::getModel('catalog/product')
          ->setStoreId(Mage::app()->getStore()->getId())
          ->load($pId);
          
        $eventArgs = array(
          'product' => $product,
          'qty' => $qty,
          'additional_ids' => array(),
        );
        
        $productParams['qty'] = $qty;
        
        if ($licenseNumber != null){
          $productParams['license_number'] = $licenseNumber;
        }
        
        if ($customPrices != null && array_key_exists($pId, $customPrices)){
          $productParams['custom_addon_price'] = $customPrices[$pId];
        }
        
        Mage::dispatchEvent('checkout_cart_before_add', $eventArgs);
        
        $cart->addProduct($product, $productParams);
        
        Mage::dispatchEvent('checkout_cart_after_add', $eventArgs);
        $cart->save();
        Mage::dispatchEvent('checkout_cart_add_product', array('product'=>$product));
        $message = Mage::helper('checkout/cart')
          ->__('%s was successfully added to your shopping cart.', $product->getName());
        Mage::getSingleton('checkout/session')->addSuccess($message);

      } catch (Mage_Core_Exception $e) {

        if (Mage::getSingleton('checkout/session')->getUseNotice(true)) {
          Mage::getSingleton('checkout/session')
            ->addNotice($product->getName() . ': ' . $e->getMessage());
        }
        else {
          Mage::getSingleton('checkout/session')
            ->addError($product->getName() . ': ' . $e->getMessage());
        }
      } catch (Exception $e) {
        Mage::getSingleton('checkout/session')
          ->addException($e, Mage::helper('checkout/cart')
                         ->__('Can not add item to shopping cart'));
      }
    }
  }

  function currDir(){
    $filename = explode("/", __FILE__); // THIS WILL BREAK DOWN THE PATH INTO AN ARRAY
    $filename2 = '';
    for( $i = 0; $i < (count($filename) - 1); ++$i ) {
      $filename2 .= $filename[$i].'/';
    }
    return $filename2;
  } 

}