<?php
/**
 * An overriding class for Magento's core Quote.php class.  Overrides a couple functions
 * to support License addons in the ordering process and cart.
 */
class Accelereyes_License_Model_Quote extends Mage_Sales_Model_Quote{

  /**
   * OVERRIDDEN: To differentiate different license-bound addons in the cart
   */
  public function getItemByProduct($product){
    $matchingProduct = parent::getItemByProduct($product);
    if (!$matchingProduct) return false;

    if ($matchingProduct->getLicenseNumber() == $product->getLicenseNumber()){
      return $matchingProduct;
    }

    return false;

  }

      
  /**
   * OVERRIDDEN: To save custom price, license number, and description to cart item
   *
   * NOTES:  This is a pretty big method to override, copy-paste.  Barely less fragile
   *         than hacking core Quote.php itself but this override seemed slightly 
   *         better in case we ever upgrade Magento.
   */
  public function addProduct(Mage_Catalog_Model_Product $product, $request=null){
    if ($request === null) {
      $request = 1;
    }
    if (is_numeric($request)) {
      $request = new Varien_Object(array('qty'=>$request));
    }
    if (!($request instanceof Varien_Object)) {
      Mage::throwException(Mage::helper('sales')->__('Invalid request for adding product to quote'));
    }

    $cartCandidates = $product->getTypeInstance(true)
        ->prepareForCart($request, $product);

    /**
     * Error message
     */

    if (is_string($cartCandidates)) {
      return $cartCandidates;
    }

    /**
     * If prepare process return one object
     */
    if (!is_array($cartCandidates)) {
      $cartCandidates = array($cartCandidates);
    }

    $parentItem = null;
    $errors = array();
    foreach ($cartCandidates as $candidate) {
      $item = $this->_addCatalogProduct($candidate, $candidate->getCartQty());

      /**
       * As parent item we should always use the item of first added product
       */
      if (!$parentItem) {
        $parentItem = $item;
      }
      if ($parentItem && $candidate->getParentProductId()) {
        $item->setParentItem($parentItem);
      }

      /*** ACCELEREYES HACK (Only reason we are overriding this method) ***/

      if ($request != null && $request->getLicenseNumber() != null){
        // NOTE: If you change the format of this description you MUST also
        //       edit the License Observer.php as it parses out the license number
        $item->setDescription("(addon for license " . $request->getLicenseNumber() . ")");
        $item->setLicenseNumber($request->getLicenseNumber());
        $item->setCustomPrice($request->getCustomAddonPrice());
      }

      /*** END ACCELEREYES HACK ***/

      /**
       * We specify qty after we know about parent (for stock)
       */
      $item->addQty($candidate->getCartQty());

      // collect errors instead of throwing first one
      if ($item->getHasError()) {
        $errors[] = $item->getMessage();
      }
    }

    if (!empty($errors)) {
      Mage::throwException(implode("\n", $errors));
    }

    return $item;
  }    

}


?>